<?php

class Ultimate_AI_SD_Manager
{
  private $api_key = "";
  private $sd_create_image_end_point_v4 = "https://stablediffusionapi.com/api/v4/dreambooth";
  private $sd_image_to_image_end_point_v4 = "https://stablediffusionapi.com/api/v4/dreambooth/img2img";
  private $sd_create_image_end_point = "https://stablediffusionapi.com/api/v3/text2img";
  private $sd_image_to_image_end_point = "https =>//stablediffusionapi.com/api/v3/img2img";
  private $sizes = ["small" => "256", "medium" => "512", "large" => "1024"];


  function __construct()
  {
    //get the api key from db and set it to $api_key variable;	
    $theme_settings_manager = new Ultimate_AI_Theme_Setting_Manager();
    $open_ai_settings = $theme_settings_manager->ultimate_ai_get_theme_settings(["uai_image_ai_settings"]);
    $this->api_key = $open_ai_settings["uai_image_ai_settings"]["stable_diffusion_key"] ?? "";
  }

  function ultimate_ai_sd_create_image($over_write_args = [])
  {
    $default_args = $this->ultimate_ai_sd_default_params();
    $args = array_merge($default_args, $over_write_args);

    //set width/height for the params
    if (in_array($over_write_args["size"], $this->sizes)) {
      $args["width"] = $this->sizes[$over_write_args["size"]];
      $args["height"] = $this->sizes[$over_write_args["size"]];
    } else {
      $args["width"] = $this->sizes["medium"];
      $args["height"] = $this->sizes["medium"];
    }

    $req_url = $args["model_id"] ? $this->sd_create_image_end_point_v4 : $this->sd_create_image_end_point;

    return $this->remote_req_wrapper(
      $req_url,
      [
        "headers" => ["Content-Type"  => "application/json"],
        "body" => json_encode($args),
        "timeout" => 60
      ],
      "POST"
    );
  }

  function ultimate_ai_sd_create_image_variation($over_write_args)
  {
    $default_args = $this->ultimate_ai_sd_default_params();
    $args = array_merge($default_args, $over_write_args);

    //set width/height for the params
    if (in_array($over_write_args["size"], $this->sizes)) {
      $args["width"] = $this->sizes[$over_write_args["size"]];
      $args["height"] = $this->sizes[$over_write_args["size"]];
    } else {
      $args["width"] = $this->sizes["medium"];
      $args["height"] = $this->sizes["medium"];
    }

    $req_url = $args["model_id"] ? $this->sd_image_to_image_end_point_v4 : $this->sd_image_to_image_end_point;

    return $this->remote_req_wrapper(
      $req_url,
      [
        "headers" => ["Content-Type"  => "application/json"],
        "body" => json_encode($args),
        "timeout" => 60
      ],
      "POST"
    );
  }

  private function remote_req_wrapper($url, $args, $method)
  {
    if ($method == "POST")  $responce = wp_remote_post($url, $args);
    if ($method == "GET")   $responce = wp_remote_get($url, $args);

    $res_status = wp_remote_retrieve_response_code($responce);

    if ($res_status == 200) {
      return array(
        "status" => "success",
        "status_code" => $res_status,
        "data"  => json_decode(wp_remote_retrieve_body($responce))
      );
    }

    //if reach this line then res fail send fail responce
    return array("status" => "fail", "status_code" => $res_status, "full_res" => $responce);
  }

  private function ultimate_ai_sd_default_params()
  {
    $args = [
      "key" => $this->api_key,
      "model_id" => "",
      "prompt" => "",
      "negative_prompt" => null,
      "init_image" => "",
      "width" => "512",
      "height" => "512",
      "samples" => "1",
      "num_inference_steps" => "30",
      "safety_checker" => "yes",
      "enhance_prompt" => "yes",
      "guidance_scale" => 7.5,
      "strength" => 0.7,
      "scheduler" => "UniPCMultistepScheduler",
      "seed" => null,
      "lora_model" => null,
      "tomesd" => "yes",
      "use_karras_sigmas" => "yes",
      "vae" => null,
      "lora_strength" => null,
      "embeddings_model" => null,
      "webhook" => null,
      "track_id" => null
    ];
    return $args;
  }
}
